<?php
/**
 * Plugin Name: Tweaks for Swift Creek
 * Description: Tweaks for Swift Creek
 * Version: 2.7
 * Author: Sam Navarro
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Add Categories to Pages
 */
function add_categories_to_pages() {
    register_taxonomy_for_object_type('category', 'page');
}
add_action('init', 'add_categories_to_pages');

/**
 * Force ACF to recognize "category" taxonomy for pages
 */
add_filter('acf/location/rule_types', function ($choices) {
    $choices['Post']['page_category'] = 'Page Category';
    return $choices;
});

add_filter('acf/location/rule_values/page_category', function ($choices) {
    $categories = get_terms(array(
        'taxonomy'   => 'category',
        'hide_empty' => false,
    ));
    
    foreach ($categories as $category) {
        $choices[$category->term_id] = $category->name;
    }

    return $choices;
});

add_filter('acf/location/rule_match/page_category', function ($match, $rule, $options) {
    $category_ids = wp_get_post_terms($options['post_id'], 'category', array('fields' => 'ids'));
    if (!$category_ids) {
        return false;
    }
    
    if ($rule['operator'] === '==') {
        return in_array($rule['value'], $category_ids);
    } elseif ($rule['operator'] === '!=') {
        return !in_array($rule['value'], $category_ids);
    }

    return $match;
}, 10, 3);



/**
 * Disable Promotions in Elementor
 */
function hide_elementor_promotions_css() {
    echo '<style>
        .elementor-element-wrapper.elementor-element--promotion {
            display: none !important;
        }
    </style>';
}
add_action('admin_head', 'hide_elementor_promotions_css');
add_action('elementor/editor/after_enqueue_styles', 'hide_elementor_promotions_css');

/**
 * Hide Admin Bar Options from Editors
 */
function remove_new_button_from_admin_bar($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->remove_node('new-content');
    }
}
add_action('admin_bar_menu', 'remove_new_button_from_admin_bar', 999);

function remove_edit_profile_from_admin_bar($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->remove_node('edit-profile');
    }
}
add_action('admin_bar_menu', 'remove_edit_profile_from_admin_bar', 999);

function hide_edit_profile_with_css() {
    if (current_user_can('editor')) {
        echo '<style>.display-name.edit-profile { display: none !important; }</style>';
    }
}
add_action('admin_head', 'hide_edit_profile_with_css');
add_action('wp_head', 'hide_edit_profile_with_css');

function remove_comments_from_admin_bar($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->remove_node('comments');
    }
}
add_action('admin_bar_menu', 'remove_comments_from_admin_bar', 999);

function remove_dashboard_from_admin_bar($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->remove_node('dashboard');
    }
}
add_action('admin_bar_menu', 'remove_dashboard_from_admin_bar', 999);

function modify_site_name_link($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->add_node([
            'id'    => 'site-name',
            'href'  => admin_url('edit.php?post_type=page'),
        ]);
    }
}
add_action('admin_bar_menu', 'modify_site_name_link', 999);

/**
 * Hide WordPress Logo from Admin Bar
 */
function remove_wp_logo_from_admin_bar($wp_admin_bar) {
    if (current_user_can('editor')) {
        $wp_admin_bar->remove_node('wp-logo');
    }
}
add_action('admin_bar_menu', 'remove_wp_logo_from_admin_bar', 999);

/**
 * New Layout for the "New Page" in Gutenberg before going to Elementor
 */
function hide_elements_for_editors() {
    if (current_user_can('editor')) {
        echo '<style> 
            .editor-document-bar, 
            .editor-preview-dropdown, 
            button[data-tab-id="edit-post/block"], 
            .is-root-container,
            .editor-document-tools__left, 
            .rttpg-import-button-wrapper,
            .editor-post-panel__row-label, 
            .editor-post-panel__row-control, 
            .editor-post-status,
            .editor-post-schedule__panel-dropdown,
            .editor-post-url__panel-dropdown,
            .editor-post-author__panel-toggle,
            .editor-post-parent__panel-dropdown,
            .editor-post-discussion__panel-toggle,
            .editor-private-post-last-revision__button,
            #eael-eb-popup-button
            { 
                display: none !important; 
            }
        </style>';
    }
}
add_action("admin_head", "hide_elements_for_editors");


